<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model
{
  use SoftDeletes;

  public $table = 'categories';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'name',
    'description',
    'created_by',
    'updated_by'
  ];

  protected $casts = [
    'id'  => 'integer',
    'name'  => 'string',
    'description'  => 'string',
    'created_by' => 'integer',
    'updated_by' => 'integer'
  ];

  public static $rules = [
    'name'  => 'required'
  ];

  public function trackings() {
    return $this->hasMany(\App\Tracking::class);
  }

}