<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CampaignLead extends Model
{
  //use SoftDeletes;

  public $table = 'campaign_leads';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'name',
    'phone',
    'assigned_date',
    'assigned_to',
    'created_by',
    'is_assigned',
    'campaign_id',
    'product_id'
  ];

  protected $casts = [
    'id'  => 'integer',
    'campaign_id'  => 'integer',
    'name'  => 'string',
    'phone'  => 'string',
    'created_by' => 'integer',
    'is_assigned' => 'boolean',
    //'assigned_date' => 'datetime:Y-m-d H:i:s',
    'assigned_to' => 'integer',
    'product_id'  => 'integer'
  ];

  public static $rules = [
    'name'  => 'required',
    'phone'  => 'required|numeric',
    'campaign_id' => 'required|integer'
  ];

  public function campaign() {
    return $this->belongsTo(\App\Campaign::class);
  }

  public function assignee() {
    return $this->belongsTo(\App\User::class, 'assigned_to');
  }

  public function creator() {
    return $this->belongsTo(\App\User::class, 'created_by');
  }

  public function product() {
    return $this->belongsTo(\App\Product::class);
  }

  public function sales() {
    return $this->hasMany(\App\Sale::class, 'lead_id');
  }
}