<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CampaignCost extends Model
{
  //use SoftDeletes;

  public $table = 'campaign_costs';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'campaign_id',
    'amount',
    'cost_date',
    'remark',
    'created_by',
    'is_confirmed'
  ];

  protected $casts = [
    'id'  => 'integer',
    'campaign_id'  => 'integer',
    'cost_date'  => 'date|Y-m-d',
    'amount'  => 'float',
    'remark'  => 'string',
    'is_confirmed' => 'boolean',
    'created_by' => 'integer'
  ];

  public static $rules = [
    'campaign_id'  => 'required|integer',
    'cost_date'  => 'required|date',
    'amount'  => 'required|numeric',
  ];

  public function campaign() {
    return $this->belongsTo(\App\Campaign::class);
  }

  public function creator() {
    return $this->belongsTo(\App\User::class, 'created_by');
  }
}