<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Campaign extends Model
{
  //use SoftDeletes;

  public $table = 'campaigns';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'name',
    'code',
    'link',
    'screenshot',
    'remark',
    'start_date',
    'end_date',
    'ad_type_id',
    'product_id',
    'created_by',
    'status',
    'is_confirmed'
  ];

  protected $casts = [
    'id'  => 'integer',
    'ad_type_id'  => 'integer',
    'product_id'  => 'integer',
    'name'  => 'string',
    'code'  => 'string',
    'link'  => 'string',
    'screenshot' => 'string',
    'remark' => 'string',
    'status'  => 'boolean',
    'start_date' => 'datetime:Y-m-d',
    'end_date' => 'datetime:Y-m-d',
    'created_by' => 'integer'
  ];

  public static $rules = [
    'name'  => 'required',
    'code'  => 'required',
    'link'  => 'required',
    'ad_type_id'  => 'required',
    'product_id'  => 'required',
    'screenshot'  => 'sometimes|mimes:jpg,jpeg,bmp,png'
  ];

  public function product() {
    return $this->belongsTo(\App\Product::class);
  }

  public function ad_type() {
    return $this->belongsTo(\App\AdType::class);
  }

  public function creator() {
    return $this->belongsTo(\App\User::class, 'created_by');
  }

  public function costs() {
    return $this->hasMany(\App\CampaignCost::class);
  }

  public function leads() {
    return $this->hasMany(\App\CampaignLead::class);
  }

  public function sales() {
    return $this->hasMany(\App\Sale::class);
  }
}