<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Attendance extends Model
{
  //use SoftDeletes;

  public $table = 'attendances';
  //protected $dates = ['deleted_at'];

  public $fillable = [
    'user_id',
    'assigned_by',
    'date',
    'is_absent',
    'default_leads_limit',
    'total_boost',
    'total_leads'
  ];

  protected $casts = [
    'id'  => 'integer',
    'user_id'  => 'integer',
    'assigned_by' => 'integer',
    'date'  => 'date|Y-m-d',
    'is_absent'  => 'boolean',
    'default_leads_limit' => 'integer',
    'total_leads' => 'integer',
    'total_boost' => 'integer'
  ];

  public static $rules = [
    'date'  => 'required|date_format:"Y-m-d"',
    'user_id' => 'required',
    'is_absent' => 'required'
  ];

  public function user() {
    return $this->belongsTo(\App\User::class, 'user_id');
  }

  public function assignee() {
    return $this->belongsTo(\App\User::class, 'assigned_by');
  }
}